# SourceRPG release 2.0.0 by Steven Hartin
# ./sourcerpg/addons/mysql_connection/mysql_connection.py

#################################
#### DO NOT EDIT THIS FILE, #####
####    IF YOU DO, THINGS   #####
####   THINGS COULD BREAK   #####
#################################

import pymysql

import time
import os
from path import path as Path

import es
import cfglib
import cmdlib
from sourcerpg import sourcerpg

class MySQLDatabaseManager(sourcerpg.SQLiteManager):
    """
    This class overwrites the default database storage method. This allows us
    to keep all of the database API which we are used to, but allows us to
    manage MySQL connections instead.
    """
    class NonStringArg(object):
        """
        As some MySQL strings needs to be left without wrapping quotation marks,
        we will make a new type which is not of type basestring which will
        host the __str__ function to convert to the original type. This means
        that any object of this type will not be wrapped in quotation marks;
        e.g. CREATE DATABASE test. The "test" will not be wrapped in quotation
        marks allowing correct use of MySQL strings.
        """
        def __init__(self, value):
            """
            Default constructer, initialise this object with a value.

            @param basestring value A string to initialise the object with
            """
            if not isinstance(value, basestring):
                raise ValueError("Expecting type basestring, instead got %s" % type(value).__name__)
            self.value = value

        def __str__(self):
            """
            Executed when this object is converted to a string; simply return
            then value of this object.

            @return string The value of this object.
            """
            return self.value
        
    def __init__(self, *args, **kw):
        """
        Set up the MySQL connection. This will be where the connection is
        created, and any cursors are initialised. All database, tables and
        starting values must be assigned here.
        """
        self.path = "MySQL: %s@%s" % (mysqlUser, mysqlHostName)
        self.lastSaved = time.time()
        if str(mysqlUnixSocket):
            self.connection = pymysql.connect(host=str(mysqlHostName), user=str(mysqlUser), passwd=str(mysqlPassword), unix_socket=str(mysqlUnixSocket))
        else:
            self.connection = pymysql.connect(host=str(mysqlHostName), user=str(mysqlUser), passwd=str(mysqlPassword))
        self.cursor = self.connection.cursor()

        try:
            self.execute("CREATE DATABASE IF NOT EXISTS ?", self.NonStringArg(str(mysqlDatabase)))
        except:
            pass
        try:
            self.execute("USE ?", self.NonStringArg(str(mysqlDatabase)))
        except:
            raise ValueError("Cannot connect to database %s and do not have permission to create either" % mysqlDatabase)

        """ Create the table to hold the players global stats """
        self.execute("""\
CREATE TABLE IF NOT EXISTS Player (
    UserID  INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT ,
    steamid VARCHAR(30) NOT NULL,
    level   INTEGER DEFAULT 1,
    xp      INTEGER DEFAULT 0,
    credits INTEGER DEFAULT 5,
    popup   INTEGER DEFAULT 1,
    name    VARCHAR(50) DEFAULT 'default',
    lastconnected INTEGER
)""")

        """ Create the table to hold a link between a row id and a list of skill names """
        self.execute("""\
CREATE TABLE IF NOT EXISTS Skill (
    SkillID INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT,
    name    VARCHAR(50) NOT NULL,
    UserID  INTEGER NOT NULL,
    level   INTEGER DEFAULT 0
)""")

    @staticmethod
    def convertFromSQLite(args):
        """
        Convert the SQLite database into the MySQL database ensuring that all
        stats are made consistent throughout.
        """
        sourcerpg.players.clearList()
        tempDB = sourcerpg.SQLiteManager(sourcerpg.databasePath)
        uidinsert   = "INSERT INTO Player (steamid, level, xp, credits, popup, name, lastConnected) VALUES (\"%s\", %s, %s, %s, %s, \"%s\", %s)"
        skillinsert = "INSERT INTO Skill (UserID, name, level) VALUES (%s, \"%s\", %s)"
        query = "SELECT UserID, steamid, level, xp, credits, popup, name, lastConnected FROM Player"
        tempDB.execute(query)

        players = map(lambda x: list(x[:6]) + [x[6].replace('"', '\\"').replace("'", "\\'")] + [int(float(x[7]))], tempDB.cursor.fetchall())

        for player in players:
            try:
                query = "SELECT name, level FROM Skill WHERE UserID=?"
                tempDB.cursor.execute(query, (player[0],) )
                skills = tempDB.cursor.fetchall()
                sourcerpg.database.cursor.execute(uidinsert, tuple(player[1:]))
                uid = sourcerpg.database.cursor.lastrowid
                skills = tuple(map(lambda x: tuple([uid] + list(x)), skills))
                sourcerpg.database.cursor.executemany(skillinsert, skills)
            except:
                es.dbgmsg(0, "[SourceRPG] Error converting SteamID %s" % (player[1]))
                continue
        
        sourcerpg.database.save(True)
        for player in es.getUseridList():
            sourcerpg.players.addPlayer(player)
        sourcerpg.es_map_start({})
        es.server.queuecmd('mp_restartgame 1')

    def execute(self, statement, *args):
        """
        Executes a statement from a given query. This enables us to provide a
        static API to user similar statements throughout sqlite and mysql
        without altering functionality of all functions to modify queries.

        Since SQLite uses "?" to denote string replacement / insertion, we
        will ensure that all questionmarks are replaced with the MySQL
        alternative of %s. If we user ? throughout the mod as the default,
        then this should work fine.

        @param string statement The SQL statement to execute
        """
        statement = statement.replace("?", "%s")
        trueArgs = []
        for arg in args:
            if isinstance(arg, basestring):
                arg = '"%s"' % arg
            trueArgs.append(arg)
        trueArgs = tuple(trueArgs)

        self.cursor.execute(statement, trueArgs)

    def save(self, force=False):
        """
        Executed when this object is called to be saved. Because of player's
        having the ability to call the database to save upon disconnect, we
        will put in protection so people can't spam this to crash the server.
        The database can only be saved every 10 seconds, and therefore if a
        player disconnects and instantly rejoins another server, the maximum
        possible loss is only 10 seconds worth of gameplay.
        """
        if time.time() - self.lastSaved > 10 or force is True:
            self.lastSaved = time.time()
            sourcerpg.SQLiteManager.save(self)

def player_disconnect(event_var):
    """
    Executed when the database saves. Ensure that we save the database so if
    the player joins another server with the same database, the latest stats
    are refreshed.

    @param event_var An automatically passed event instance.1qw
    """
    sourcerpg.database.save()

def load():
    """
    This executes when the addon loads. Ensure that we assign the database
    storage method to this MySQL manager instead of the SQLiteManager.
    """
    cmdlib.registerServerCommand("convert_sqlite_to_mysql", MySQLDatabaseManager.convertFromSQLite, "Converts the SQLite DB to MySQL DB")
    config.write()
    es.server.cmd("")
    config.execute(False)
    sourcerpg.DATABASE_STORAGE_METHOD = MySQLDatabaseManager
    if sourcerpg.database is not None:
        sourcerpg.players.clearList()
        sourcerpg.database.save()
        sourcerpg.database.close()
        sourcerpg.database = sourcerpg.DATABASE_STORAGE_METHOD()
        sourcerpg.es_map_start({})
        for player in es.getUseridList():
            sourcerpg.players.addPlayer(player)
        es.server.queuecmd("mp_restartgame 1")

def unload():
    """
    This executes when this addon is unloaded. We want to save this database,
    then open up the default SQLiteManager with the default configuration.
    """
    cmdlib.unregisterServerCommand("convert_sqlite_to_mysql")
    sourcerpg.players.clearList()
    sourcerpg.DATABASE_STORAGE_METHOD = sourcerpg.SQLiteManager
    sourcerpg.database.save()
    sourcerpg.database.close()
    sourcerpg.database = sourcerpg.DATABASE_STORAGE_METHOD(sourcerpg.databasePath)
    sourcerpg.es_map_start({})
    for player in es.getUseridList():
        sourcerpg.players.addPlayer(player)
    es.server.queuecmd("mp_restartgame 1")


oldCFGPath = Path(es.getAddonPath("sourcerpg")).joinpath("addons", "mysql_connection", "config.cfg")
newCFGPath = Path(str(es.ServerVar("eventscripts_gamedir"))).joinpath("cfg", "sourcerpg", "mysql_config.cfg")
if oldCFGPath.exists():
    oldCFGPath.copy(str(newCFGPath))
    oldCFGPath.remove()
config = cfglib.AddonCFG(str(newCFGPath))
config.text("MySQL Connection Version %s" % sourcerpg.info.version)
config.text("This is the configuration for your mysql server")
mysqlHostName = config.cvar("sourcerpg_mysql_host", "localhost", "The IP / HostName of the MySQL server")
mysqlUser = config.cvar("sourcerpg_mysql_user", "Root", "The username for the MySQL connection")
mysqlPassword = config.cvar("sourcerpg_mysql_password", "Password", "The passworfd for the user of the MySQL connection")
mysqlDatabase = config.cvar("sourcerpg_mysql_database", "sourcerpg_players", "The database used to store the information, leave as default unless you know what you're doing\n// Note: This will create the database if it doesn't already exist and you have the permissions")
mysqlUnixSocket = config.cvar("sourcerpg_mysql_unix_socket", "", """If you are connecting via an unix socket, please input the path to the mysql.sock.
// NOTE: This is a VERY advanced technique and should be left alone by almost everyone.
// This will only work on linux systems on a localhost, so remote servers won't work
// with this. Leave blank for no socket (default)""")