# SourceRPG release 2.0.0 by Steven Hartin
# ./sourcerpg/addons/sourcerpg_admin/sourcerpg_admin.py

#################################
#### DO NOT EDIT THIS FILE, #####
####    IF YOU DO, THINGS   #####
####   THINGS COULD BREAK   #####
#################################
import es

import os
import time

from sourcerpg import sourcerpg

from sqlite3 import dbapi2 as sqlite, OperationalError
from shutil import move

""" Import the psyco module which improves speed """
import psyco
psyco.full()

stringPath = os.path.join( es.getAddonPath( sourcerpg.info.basename ), "players.sqldb")

if not os.path.isfile(stringPath):
    raise RuntimeError, "Cannot find the player's database, please ensure it is in ../sourcerpg/"

class ReadSql(object):
    "Class to read the SQL Database from cssrpg.db"
    def __init__(self):
        self.connection = None
        self.open()

    def __del__(self):
        if self.connection is not None:
            self.close()

    def open(self):
        """
        Open the connection of the database with SQLite
        """
        self.connection = sqlite.connect(stringPath)
        self.connection.text_factory = str
        self.cursor = self.connection.cursor()

    def close(self):
        """
        Close the connection of the database with SQLite
        """
        self.connection.close()
        self.connection = None
        self.cursor = None

    def readPlayers(self):
        """
        Read a specific player's stats, including levels,
        xp annd credits etc.
        """
        query = self.cursor.execute("SELECT * FROM players")
        return query.fetchall()

def convertEntries():
    """
    This method converts all of the cssrpg's Database items over to the new database
    structure and all of SourceRPG's variable names.
    """
    rpgPlayers  = {}
    sqlInstance = ReadSql()
    players     = sqlInstance.readPlayers()
    del sqlInstance

    """ Iterate through the players """
    for player in xrange(len(players)):
        steamid = str(players[player][0])
        if steamid == "BOT":
            steamid = "BOT_%s"%(players[player][24])
        rpgPlayers[steamid]                              = {}
        rpgPlayers[steamid]["name"]                      = players[player][24]
        rpgPlayers[steamid]["level"]                     = players[player][1]
        rpgPlayers[steamid]["xp"]                        = players[player][2]
        rpgPlayers[steamid]["credits"]                   = players[player][3]
        rpgPlayers[steamid]["popup"]                     = players[player][21]
        rpgPlayers[steamid]["lastconnected"]             = players[player][25]
        rpgPlayers[steamid]["skills"]                    = {}
        rpgPlayers[steamid]["skills"]["Regen"]           = players[player][4]
        rpgPlayers[steamid]["skills"]["Health"]          = players[player][5]
        rpgPlayers[steamid]["skills"]["Regen Ammo"]      = players[player][6]
        rpgPlayers[steamid]["skills"]["Regen Armor"]     = players[player][20]
        rpgPlayers[steamid]["skills"]["Vampire"]         = players[player][8]
        rpgPlayers[steamid]["skills"]["Stealth"]         = players[player][7]
        rpgPlayers[steamid]["skills"]["Long Jump"]       = players[player][12]
        rpgPlayers[steamid]["skills"]["Napalm Grenade"]  = players[player][9]
        rpgPlayers[steamid]["skills"]["Ice Stab"]        = players[player][10]
        rpgPlayers[steamid]["skills"]["Frost Pistol"]    = players[player][11]
        rpgPlayers[steamid]["skills"]["Adrenaline"]      = players[player][22]
        rpgPlayers[steamid]["skills"]["Recover Weapons"] = players[player][17]
        rpgPlayers[steamid]["skills"]["Medic"]           = players[player][23]
        rpgPlayers[steamid]["skills"]["Speed"]           = players[player][13]
        rpgPlayers[steamid]["skills"]["Gravity"]         = players[player][14]
        rpgPlayers[steamid]["skills"]["Stun Grenade"]    = players[player][15]
        rpgPlayers[steamid]["skills"]["Smog Grenade"]    = players[player][16]
        rpgPlayers[steamid]["skills"]["Disable"]         = players[player][18]

    return rpgPlayers

def writeEntries():
    """
    This loops through the SQL Converted DB (which is now a dictionary),
    and checks it against the players.db... If the SteamID's are different,
    then that SteamID is appended to player.db, then at the end, remove the
    players.sqldb, and write the players.sqlite to disk
    """
    entries = convertEntries()
    print "Estimated time: %02d:%02d" % divmod(int(0.0125 * len(entries)), 60)
    now = time.time()
    for steamid, values in entries.iteritems():
        """ Loop through all the steamids in the converted entries """
        try:
            if steamid in sourcerpg.database:
                """ If the player exists, remove them from the database """
                UserID = sourcerpg.database.getUserIdFromSteamId(steamid) 
                sourcerpg.database.cursor.execute("DELETE FROM Player WHERE UserID=?", (UserID,) )
                sourcerpg.database.cursor.execute("DELETE FROM Skill WHERE UserID=?", (UserID,) )

            """ Add the player instance into the database with default values """
            sourcerpg.database.cursor.execute("""INSERT INTO Player
                                    (steamid, popup, credits, name, level, xp, lastconnected)
                                    VALUES (?,?,?,?,?,?,?)""",
                                    (steamid, int(sourcerpg.popupStatus), values['credits'],
                                    values['name'].replace("'", "''"), values['level'],
                                    values['xp'], now) )
            userid = sourcerpg.database.cursor.lastrowid
            for skillName, level in values['skills'].iteritems():
                """ Loop through all the converted skills and attributes """
                if not level:
                    """ Don't make any skills which don't have a level """
                    continue
                """ Obtain the rowid from the database and set the new skill """
                sourcerpg.database.cursor.execute("INSERT INTO Skill (name, UserID, level) VALUES (?,?,?)",
                                                    (skillName, userid, level) )

        except OperationalError:
            """ We got an error, ignore it and continue to the next person. """
            continue

    """ Check to see if a backup folder is created, if not, create it. """
    directory = os.path.join(es.getAddonPath( sourcerpg.info.basename ), "backup")
    if not os.path.isdir(directory):
       os.mkdir(directory)

    """ Move the cssrpgd database to a new directory and save the main databse. """
    move(stringPath, os.path.join(directory, "players.sqldb") )
    sourcerpg.database.save()

    """ Restart the mod then change maps to take effect """
    es.reload(sourcerpg.info.basename)
    es.server.queuecmd('changelevel %s' % es.ServerVar('eventscripts_currentmap') )

""" Start the process to write the entries """
writeEntries()