# SourceRPG release 2.0.0 by Steven Hartin
# ./sourcerpg/addons/sourcerpg_admin/sourcerpg_admin.py

#################################
#### DO NOT EDIT THIS FILE, #####
####    IF YOU DO, THINGS   #####
####   THINGS COULD BREAK   #####
#################################
import es

import os
import time

from sourcerpg import sourcerpg

from sqlite3 import dbapi2 as sqlite, OperationalError
from shutil import move

""" Import the psyco module which improves speed """
import psyco
psyco.full()

stringPath = os.path.join( es.getAddonPath( sourcerpg.info.basename ), "cssrpg.db")

if not os.path.isfile(stringPath):
    raise RuntimeError, "Cannot find CSS:RPG database, please ensure it is in ../sourcerpg/"

class ReadSql(object):
    "Class to read the SQL Database from cssrpg.db"
    def __init__(self):
        self.connection = None
        self.open()

    def __del__(self):
        if self.connection is not None:
            self.close()

    def open(self):
        """
        Open the connection of the database with SQLite
        """
        self.connection = sqlite.connect(stringPath)
        self.connection.text_factory = str
        self.cursor = self.connection.cursor()

    def close(self):
        """
        Close the connection of the database with SQLite
        """
        self.connection.close()
        self.connection = None
        self.cursor = None

    def readItems(self):
        """
        Read all items (skills) from the SQL Database
        """
        query = self.cursor.execute("SELECT * FROM items")
        return query.fetchall()

    def readPlayers(self):
        """
        Read a specific player's stats, including levels,
        xp annd credits etc.
        """
        query = self.cursor.execute("SELECT * FROM players")
        return query.fetchall()

def convertEntries():
    """
    This method converts all of the cssrpg's Database items over to the new database
    structure and all of SourceRPG's variable names.
    """
    rpgPlayers  = {}
    itemID      = {}
    rpgName     = ["Speed", "Gravity", "Stun Grenade", "Smog Grenade", "Disable", "Armor"]
    sqlInstance = ReadSql()
    players     = sqlInstance.readPlayers()
    skills      = sqlInstance.readItems()
    del sqlInstance

    """ Iterate through the players """
    for player in xrange(len(players)):
        steamid = str(players[player][2])
        if steamid == "BOT":
            steamid = "BOT_%s"%(players[player][1])
        rpgPlayers[steamid] = {}
        rpgPlayers[steamid]["name"]    = players[player][1]
        rpgPlayers[steamid]["level"]   = players[player][3]
        rpgPlayers[steamid]["xp"]      = players[player][4]
        rpgPlayers[steamid]["credits"] = players[player][5]
        itemID[players[player][8]] = steamid

    """ Loop through the skills table and add all the values to the dictioanry """
    for x in xrange(len(skills)):
        try:
            if skills[x][0] in itemID:
                steamid = itemID[skills[x][0]]
                rpgPlayers[steamid]["skills"] = {}
                rpgPlayers[steamid]["skills"]["Regen"]           = skills[x][1]
                rpgPlayers[steamid]["skills"]["Health"]          = skills[x][2]
                rpgPlayers[steamid]["skills"]["Regen Ammo"]      = skills[x][3]
                rpgPlayers[steamid]["skills"]["Vampire"]         = skills[x][4]
                rpgPlayers[steamid]["skills"]["Stealth"]         = skills[x][5]
                rpgPlayers[steamid]["skills"]["Long Jump"]        = skills[x][6]
                rpgPlayers[steamid]["skills"]["Napalm Grenade"]  = skills[x][7]
                rpgPlayers[steamid]["skills"]["Ice Stab"]        = skills[x][8]
                rpgPlayers[steamid]["skills"]["Frost Pistol"]    = skills[x][9]
                rpgPlayers[steamid]["skills"]["Adrenaline"]      = skills[x][10]
                rpgPlayers[steamid]["skills"]["Recover Weapons"] = skills[x][11]
                rpgPlayers[steamid]["skills"]["Medic"]           = skills[x][12]
        except IndexError:
            pass

    """ Loop through the players and add in the missing new values """
    for player in rpgPlayers:
        if len(rpgPlayers[player]) == 16:
            for iterator in rpgPlayers[player]:
                rpgPlayers[player]["skills"][rpgName[iterator]] = 0
    return rpgPlayers

def writeEntries():
    """
    This loops through the SQL Converted DB (which is now a dictionary),
    and checks it against the players.db... If the SteamID's are different,
    then that SteamID is appended to player.db, then at the end, remove the
    cssrpg.db, and write the players.db to disk
    """
    entries = convertEntries()
    now     = time.time()
    print "Estimated time: %02d:%02d" % divmod(int(0.0125 * len(entries)), 60)

    for steamid, values in entries.iteritems():
        """ Loop through all the steamids in the converted entries """
        try:

            if steamid in sourcerpg.database:
                """ If the player exists, remove them from the database """
                UserID = sourcerpg.database.getUserIdFromSteamId(steamid) 
                sourcerpg.database.cursor.execute("DELETE FROM Player WHERE UserID=?", (UserID,) )
                sourcerpg.database.cursor.execute("DELETE FROM Skill WHERE UserID=?", (UserID,) )

            """ Add the player instance into the database with default values """
            sourcerpg.database.cursor.execute("""INSERT INTO Player
                                    (steamid, popup, credits, name, level, xp, lastconnected)
                                    VALUES (?,?,?,?,?,?,?)""",
                                    (steamid, int(sourcerpg.popupStatus), values['credits'],
                                    values['name'].replace("'", "''"), values['level'],
                                    values['xp'], now) )
            userid = sourcerpg.database.cursor.lastrowid
            for skillName, level in values['skills'].iteritems():
                """ Loop through all the converted skills and attributes """
                if not level:
                    """ Don't make any skills which don't have a level """
                    continue
                """ Obtain the rowid from the database and set the new skill """
                sourcerpg.database.cursor.execute("INSERT INTO Skill (name, UserID, level) VALUES (?,?,?)",
                                                    (skillName, userid, level) )
                            
        except OperationalError:
            """ We got an error, ignore it and continue to the next person. """
            print "ERRORZ"
            continue

    """ Check to see if a backup folder is created, if not, create it. """
    directory = os.path.join(es.getAddonPath( sourcerpg.info.basename ), "backup")
    if not os.path.isdir(directory):
       os.mkdir(directory)

    """ Move the cssrpgd database to a new directory and save the main databse. """
    move(stringPath, os.path.join(directory, "cssrpg.db") )
    sourcerpg.database.save()

    """ Restart the mod then change maps to take effect """
    es.reload(sourcerpg.info.basename)
    es.server.queuecmd('changelevel %s' % es.ServerVar('eventscripts_currentmap') )

""" Start the process to write the entries """
writeEntries()