﻿# This file shouldn't be edited!
# For editing please check ../cfg/eventscripts/super_admin_cheetah/config.cfg

import es
import cfglib
import cmdlib
import random
import langlib
import usermsg
import popuplib
import playerlib
import gamethread
from time import strftime

import psyco
psyco.full()

addonpath = "super_admin_cheetah"

SAC_Dict_Gravity = {}
SAC_Dict_Shaking = {}
SAC_Dict_Ammo = {}
SAC_Dict_Regeneration = {}
SAC_Dict_Disguise = {}
SAC_Dict_Blind = {}
SAC_Dict_Saveloc = {}
SAC_Dict_Burn = {}
SAC_Dict_Drug = {}

variables = [
        ["sac_version","v1.0CheeTaH-Public","Script version.",1],
        ["sac_consolecommand","0","Command brought by SAC",0],
        ["sac_saycommand","0","Command brought by SAC",0],
        ["sac_cmd_respawn","0","Command brought by SAC",0],
        ["sac_cmd_godmode","0","Command brought by SAC",0],
        ["sac_cmd_speed","0","Command brought by SAC",0],
        ["sac_cmd_jetpack","0","Command brought by SAC",0],
        ["sac_cmd_gravity","0","Command brought by SAC",0],
        ["sac_cmd_invisible","0","Command brought by SAC",0],
        ["sac_cmd_shake","0","Command brought by SAC",0],
        ["sac_cmd_unlimitedammo","0","Command brought by SAC",0],
        ["sac_cmd_disarm","0","Command brought by SAC",0],
        ["sac_cmd_regeneration","0","Command brought by SAC",0],
        ["sac_cmd_disguise","0","Command brought by SAC",0],
        ["sac_cmd_bury","0","Command brought by SAC",0],
        ["sac_cmd_blind","0","Command brought by SAC",0],
        ["sac_cmd_kill","0","Command brought by SAC",0],
        ["sac_cmd_saveloc","0","Command brought by SAC",0],
        ["sac_cmd_teleport","0","Command brought by SAC",0],
        ["sac_cmd_burn","0","Command brought by SAC",0],
        ["sac_cmd_drug","0","Command brought by SAC",0],
        ["sac_cmd_slap","0","Command brought by SAC",0],
    ]

ini = cfglib.AddonINI(es.getAddonPath(addonpath) + '/translations.ini')
translations = langlib.Strings(ini)
    
def load():
    SetUpVariables()
    for Player in playerlib.getUseridList('#human'): tell(Player, translations('load_msg', {'version':es.ServerVar("sac_version")}, Lang(Player)))
    es.server.queuecmd("mp_restartgame 1")
    gamethread.delayedname(4, "Updater", Updater)
    global SACMenu_Main
    SACMenu_Main = popuplib.easymenu('SACMenu_Main',None, MenuHandler1)
    SACMenu_Main.settitle("- Super Admin CheeTaH")
    SACMenu_Main.addoption('Fun Commands', "Fun Commands")
    SACMenu_Main.addoption('Music', "Music")
    SACMenu_Main.addoption('Propmenu', "Propmenu")
    SACMenu_Main.addoption('Mini-Games', "Mini-Games")
    SACMenu_Main.addoption('Admin Management', "Admin Management")
    
    global SACMenu_Fun
    SACMenu_Fun = popuplib.easymenu('SACMenu_Fun',None, MenuHandler3)
    SACMenu_Fun.submenu(10, SACMenu_Main)
    SACMenu_Fun.settitle("- Super Admin CheeTaH")
    SACMenu_Fun.setdescription("-- Fun Commands")
    SACMenu_Fun.addoption('Respawn', "Respawn")
    SACMenu_Fun.addoption('Godmode', "Godmode")
    SACMenu_Fun.addoption('Speed', "Speed")
    SACMenu_Fun.addoption('Jetpack', "Jetpack")
    SACMenu_Fun.addoption('Gravity', "Gravity")
    SACMenu_Fun.addoption('Invisible', "Invisible")
    SACMenu_Fun.addoption('Shake', "Shake")
    SACMenu_Fun.addoption('Unlimited Ammo', "Unlimited Ammo")
    SACMenu_Fun.addoption('Disarm', "Disarm")
    SACMenu_Fun.addoption('Regeneration', "Regeneration")
    SACMenu_Fun.addoption('Disguise', "Disguise")
    SACMenu_Fun.addoption('Bury', "Bury")
    SACMenu_Fun.addoption('Blind', "Blind")
    SACMenu_Fun.addoption('Slay', "Slay")
    SACMenu_Fun.addoption('Save Location', "Save Location")
    SACMenu_Fun.addoption('Teleport', "Teleport")
    SACMenu_Fun.addoption('Burn', "Burn")
    SACMenu_Fun.addoption('Drug', "Drug")
    SACMenu_Fun.addoption('Slap', "Slap")
    
    global SACMenu_Music
    SACMenu_Music = popuplib.easymenu('SACMenu_Music',None, MusicPlayer)
    SACMenu_Music.submenu(10, SACMenu_Main)
    SACMenu_Music.settitle("- Super Admin CheeTaH")
    SACMenu_Music.setdescription("-- Music")
    SACMenu_Music.addoption("music/Ravenholm_1.mp3", "Sound 1 [0:30 - Calm]")
    SACMenu_Music.addoption("music/HL2_song10.mp3", "Sound 2 [0:31 - Calm]")
    SACMenu_Music.addoption("music/HL2_song11.mp3", "Sound 3 [0:35 - Calm]")
    SACMenu_Music.addoption("music/HL2_song6.mp3", "Sound 4 [0:46 - Action]")
    SACMenu_Music.addoption("music/HL2_song7.mp3", "Sound 5 [0:51 - Calm]")
    SACMenu_Music.addoption("music/HL2_song13.mp3", "Sound 6 [0:54 - Calm]")
    SACMenu_Music.addoption("music/HL2_song8.mp3", "Sound 7 [1:00 - Calm]")
    SACMenu_Music.addoption("music/HL2_song17.mp3", "Sound 8 [1:00 - Calm]")
    SACMenu_Music.addoption("music/HL2_song4.mp3", "Sound 9 [1:05 - Action]")
    SACMenu_Music.addoption("music/HL2_song12_long.mp3", "Sound 10 [1:10 - Action]")
    SACMenu_Music.addoption("music/HL2_song15.mp3", "Sound 11 [1:10 - Action]")
    SACMenu_Music.addoption("music/HL2_song3.mp3", "Sound 12 [1:30 - Action]")
    SACMenu_Music.addoption("music/HL2_song1.mp3", "Sound 13 [1:40 - Calm]")
    SACMenu_Music.addoption("music/HL2_song30.mp3", "Sound 14 [1:43 - Calm]")
    SACMenu_Music.addoption("music/HL2_song19.mp3", "Sound 15 [1:56 - Calm]")
    SACMenu_Music.addoption("music/HL2_song29.mp3", "Sound 16 [2:19 - Action]")
    SACMenu_Music.addoption("music/HL2_song20_submix4.mp3", "Sound 17 [2:20 - Action]")
    SACMenu_Music.addoption("music/HL2_song14.mp3", "Sound 18 [2:37 - Action]")
    SACMenu_Music.addoption("music/HL2_song16.mp3", "Sound 19 [2:50 - Action]")
    SACMenu_Music.addoption("music/HL2_song2.mp3", "Sound 20 [2:51 - Calm]")
    
    global SACMenu_Propmenu
    SACMenu_Propmenu = popuplib.easymenu('SACMenu_Propmenu',None, PropCreator)
    SACMenu_Propmenu.submenu(10, SACMenu_Main)
    SACMenu_Propmenu.settitle("- Super Admin CheeTaH")
    SACMenu_Propmenu.setdescription("-- Prop Menu")
    SACMenu_Propmenu.addoption("DelThis", "   Delete This Prop")
    SACMenu_Propmenu.addoption("DelAll", "   Delete All")
    SACMenu_Propmenu.addoption("D|toilet|/props/cs_militia/toilet", "Toilet")
    SACMenu_Propmenu.addoption("P|barrel|props_c17/oildrum001", "Barrel")
    SACMenu_Propmenu.addoption("P|explosive barrel|props_c17/oildrum001_explosive", "Explosive Barrel")
    SACMenu_Propmenu.addoption("D|rock|props/de_inferno/de_inferno_boulder_01", "Rock")
    SACMenu_Propmenu.addoption("D|lamppost|props_c17/lamppost03a_off", "Lamppost")
    SACMenu_Propmenu.addoption("D|table|props/cs_militia/table_kitchen", "Table")
    SACMenu_Propmenu.addoption("P|cabinet|props/cs_office/file_cabinet3", "Cabinet")
    SACMenu_Propmenu.addoption("D|fountain|props/de_inferno/fountain", "Fountain")
    SACMenu_Propmenu.addoption("D|propane machine|props/de_train/Processor_NoBase", "Propane Machine")
    SACMenu_Propmenu.addoption("D|sofa|props/cs_militia/couch", "Sofa")
    SACMenu_Propmenu.addoption("D|pipe|props_pipes/PipeCluster32d_001a", "Pipe")
    SACMenu_Propmenu.addoption("D|wooden box|props/cs_militia/crate_extralargemill", "Wooden Box")
    
    global SACMenu_MiniGames
    SACMenu_MiniGames = popuplib.easymenu('SACMenu_MiniGames',None, MenuHandler1)
    SACMenu_MiniGames.submenu(10, SACMenu_Main)
    SACMenu_MiniGames.settitle("- Super Admin CheeTaH")
    SACMenu_MiniGames.setdescription("-- Mini Games")
    SACMenu_MiniGames.addoption('Wolves VS Sheeps', "Wolves VS Sheeps")
    SACMenu_MiniGames.addoption('Mini Zombiemod', "Mini Zombiemod")
    SACMenu_MiniGames.addoption('Stop MiniGames', "Stop the current game")
    
    global SACMenu_AdminManagement
    SACMenu_AdminManagement = popuplib.easymenu('SACMenu_AdminManagement',None, MenuHandler2)
    SACMenu_AdminManagement.submenu(10, SACMenu_Main)
    SACMenu_AdminManagement.settitle("- Super Admin CheeTaH")
    SACMenu_AdminManagement.setdescription("-- Admin Management")
    SACMenu_AdminManagement.addoption('List of admins', "List of Admins")
    SACMenu_AdminManagement.addoption('Add an Admin', "Add an Admin")
    SACMenu_AdminManagement.addoption('Remove an Admin', "Remove an Admin")
    
    cmdlib.registerClientCommand(es.ServerVar("sac_consolecommand"), client_cmd_openmenu, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_saycommand"), client_cmd_openmenu, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_respawn"), client_cmd_respawn, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_respawn"), client_cmd_respawn, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_godmode"), client_cmd_godmode, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_godmode"), client_cmd_godmode, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_speed"), client_cmd_speed, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_speed"), client_cmd_speed, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_jetpack"), client_cmd_jetpack, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_jetpack"), client_cmd_jetpack, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_gravity"), client_cmd_gravity, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_gravity"), client_cmd_gravity, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_invisible"), client_cmd_invisible, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_invisible"), client_cmd_invisible, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_shake"), client_cmd_shake, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_shake"), client_cmd_shake, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_unlimitedammo"), client_cmd_unlimitedammo, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_unlimitedammo"), client_cmd_unlimitedammo, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_disarm"), client_cmd_disarm, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_disarm"), client_cmd_disarm, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_regeneration"), client_cmd_regeneration, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_regeneration"), client_cmd_regeneration, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_disguise"), client_cmd_disguise, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_disguise"), client_cmd_disguise, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_bury"), client_cmd_bury, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_bury"), client_cmd_bury, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_blind"), client_cmd_blind, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_blind"), client_cmd_blind, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_kill"), client_cmd_kill, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_kill"), client_cmd_kill, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_saveloc"), client_cmd_saveloc, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_saveloc"), client_cmd_saveloc, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_teleport"), client_cmd_teleport, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_teleport"), client_cmd_teleport, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_burn"), client_cmd_burn, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_burn"), client_cmd_burn, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_drug"), client_cmd_drug, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_drug"), client_cmd_drug, "no comment...")
    cmdlib.registerClientCommand(es.ServerVar("sac_cmd_slap"), client_cmd_slap, "no comment...")
    cmdlib.registerSayCommand(es.ServerVar("sac_cmd_slap"), client_cmd_slap, "no comment...")

def unload():
    es.unload("%s/mini_zombiemod" %(str(addonpath)))
    es.unload("%s/wolves_vs_sheeps" %(str(addonpath)))
    gamethread.cancelDelayed("Updater")
    for Player in playerlib.getUseridList('#human'): tell(Player, translations('unload_msg', {'version':es.ServerVar("sac_version")}, Lang(Player)))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_consolecommand"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_saycommand"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_respawn"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_respawn"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_godmode"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_godmode"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_speed"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_speed"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_jetpack"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_jetpack"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_gravity"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_gravity"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_invisible"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_invisible"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_shake"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_shake"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_unlimitedammo"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_unlimitedammo"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_disarm"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_disarm"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_regeneration"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_regeneration"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_disguise"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_disguise"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_bury"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_bury"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_blind"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_blind"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_kill"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_kill"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_saveloc"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_saveloc"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_teleport"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_teleport"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_burn"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_burn"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_drug"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_drug"))
    cmdlib.unregisterClientCommand(es.ServerVar("sac_cmd_slap"))
    cmdlib.unregisterSayCommand(es.ServerVar("sac_cmd_slap"))    
def es_map_start(ev): SetUpVariables()
def player_spawn(ev):
    Player = int(ev['userid'])
    PlayerP = playerlib.getPlayer(Player)
    SAC_Dict_Gravity[int(Player)] = "1"
    SAC_Dict_Shaking[int(Player)] = "0"
    SAC_Dict_Ammo[int(Player)] = "0"
    SAC_Dict_Regeneration[int(Player)] = "0"
    SAC_Dict_Disguise[int(Player)] = "0"
    SAC_Dict_Blind[int(Player)] = 0
    SAC_Dict_Burn[int(Player)] = 0
    SAC_Dict_Drug[int(Player)] = "0"
    es.cexec(int(Player), "r_screenoverlay normal")
    es.fire(Player, "!self", "addoutput", "gravity 1")
    if PlayerP.getPrimary(): PlayerP.setWeaponColor(255, 255, 255, 255)
    elif PlayerP.getSecondary(): PlayerP.setWeaponColor(255, 255, 255, 255)
def player_death(ev):
    Player = int(ev['userid'])
    SAC_Dict_Gravity[int(Player)] = "1"
    SAC_Dict_Shaking[int(Player)] = "0"
    SAC_Dict_Ammo[int(Player)] = "0"
    SAC_Dict_Regeneration[int(Player)] = "0"
    SAC_Dict_Disguise[int(Player)] = "0"
    SAC_Dict_Blind[int(Player)] = 0
    SAC_Dict_Burn[int(Player)] = 0
    SAC_Dict_Drug[int(Player)] = "0"
    es.cexec(Player, "r_screenoverlay normal")
    es.fire(Player, "!self", "addoutput", "gravity 1")
def tell(userid, text): es.tell(userid, "#multi", "\x05SAC#default: "+str(text))
def msg(text): es.msg("#multi", "\x05SAC#default: "+str(text))
def Lang(userid): return playerlib.getPlayer(userid).getLanguage()
def NotAdmin(userid): tell(userid, translations('not_admin', None, Lang(userid)))
def addAdmin(userid, adder):
    if not (es.exists('userid',userid)): return
    if (es.isbot(userid)):
        tell(adder, translations('added_admin_is_a_bot', {'added':es.getplayername(userid)}, Lang(adder)))
        return
    File = open(es.getAddonPath(addonpath) + '/admins.txt')
    for CurrentLine in File.readlines():
        if (str(CurrentLine).lower().startswith("|steam_")):
            SplittedLine = CurrentLine.split("|")
            if (len(SplittedLine) == 4):
                if (str(SplittedLine[1]).lower() == str(es.getplayersteamid(userid)).lower()):
                    tell(adder, translations('already_admin', {'added':es.getplayername(userid)}, Lang(adder)))
                    return
    for Player in playerlib.getUseridList('#human'): tell(Player, translations('added_admin', {'adder':es.getplayername(adder),'added':es.getplayername(userid)}, Lang(Player)))
    File = open(es.getAddonPath(addonpath) + '/admins.txt', 'a')
    File.write("\n\n// %s can not add admins. He has the name %s. He was added from ingame by %s(%s) on %s\n|%s|0|%s" %(es.getplayersteamid(userid),es.getplayername(userid),es.getplayername(adder),es.getplayersteamid(adder),strftime("%Y-%m-%d %H:%M:%S"),es.getplayersteamid(userid),es.getplayername(userid)))
    File.close()

def removeAdmin(removed, remover):
    File = open(es.getAddonPath(addonpath) + '/admins.txt')
    SLine = -1
    for CurrentLine in File.readlines():
        SLine += 1
        if (str(CurrentLine).lower().startswith("|steam_")):
            SplittedLine = CurrentLine.split("|")
            if (len(SplittedLine) == 4):
                if (str(SplittedLine[3]).lower() == str(removed).lower()):
                    # delete him from the file somehow
                    filehandle = open(es.getAddonPath(addonpath) + '/admins.txt', 'r')
                    filelines = filehandle.readlines()
                    filehandle.close()
                    del filelines[SLine]
                    filehandle = open(es.getAddonPath(addonpath) + '/admins.txt', 'w')
                    filehandle.writelines(filelines)
                    filehandle.close()
                    MenuHandler2(remover, 'Remove an Admin', None)
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('removed_admin', {'remover':es.getplayername(remover),'removed':str(SplittedLine[3])}, Lang(Player)))
                    return
    
def SetUpVariables():
    for var in variables:
        vari = es.ServerVar(var[0],var[1],var[2])
        vari.set(var[1])
        if (var[3] == 1): vari.makepublic()
    es.mexec("../cfg/eventscripts/%s/config.cfg" %(addonpath))
    
def IsAdmin(userid):
    File = open(es.getAddonPath(addonpath) + '/admins.txt')
    for CurrentLine in File.readlines():
        if (str(CurrentLine).lower().startswith("|steam_")):
            SplittedLine = CurrentLine.split("|")
            if (len(SplittedLine) == 4):
                if (str(SplittedLine[1]).lower() == str(es.getplayersteamid(userid)).lower()):
                    if SplittedLine[2] == "0": return 1
                    elif SplittedLine[2] == "1": return 2
    return 0
    
def getViewProp(userid):
    returnvalue = None
    if es.exists("userid", userid):
        entities = es.createentityindexlist()
        for entity in entities:
            entities[entity]["targetname"] = es.entitygetvalue(entity, "targetname")
        es.entsetname(userid, "viewed_prop")
        for entity in entities:
            if es.entitygetvalue(entity, "targetname") != "viewed_prop":
                continue
            returnvalue = entity
            es.entitysetvalue(entity, "targetname", entities[entity]["targetname"])
            break
    return returnvalue
    
def Updater():
    for Player in playerlib.getUseridList('#alive'):
        if SAC_Dict_Drug[int(Player)] != "0": es.cexec(Player, "r_screenoverlay effects/tp_eyefx/tp_eyefx")
        if SAC_Dict_Shaking[int(Player)] != "0": usermsg.shake(Player, SAC_Dict_Shaking[int(Player)], 0.1)
        if SAC_Dict_Blind[int(Player)] != "0": usermsg.fade(Player, 2, 1, 100, 0, 0, 0, SAC_Dict_Blind[int(Player)])
        if SAC_Dict_Burn[int(Player)] > 0:
            SAC_Dict_Burn[int(Player)] -= 1
            es.fire(Player, "!self", "IgniteLifetime", 0.1)
            if (random.randint(1,5) == 1):
                playerlib.getPlayer(Player).setHealth(int(playerlib.getPlayer(Player).getHealth()) - 1)
                if (playerlib.getPlayer(Player).getHealth() < 1): playerlib.getPlayer(Player).slay()
        if SAC_Dict_Regeneration[int(Player)] != "0":
            if (int(playerlib.getPlayer(Player).getHealth()) < 100): playerlib.getPlayer(Player).setHealth(int(playerlib.getPlayer(Player).getHealth()) + 1)
        if SAC_Dict_Ammo[int(Player)] != "0":
            PlayerP = playerlib.getPlayer(Player)
            if PlayerP.getPrimary():
                PlayerP.setClip(PlayerP.getPrimary(), 999)
                PlayerP.setAmmo(PlayerP.getPrimary(), 0)
            if PlayerP.getSecondary():
                PlayerP.setClip(PlayerP.getSecondary(), 999)
                PlayerP.setAmmo(PlayerP.getSecondary(), 0)
    gamethread.delayedname(.1, "Updater", Updater)
    
    
    
    ###################
    ### ########### ###
    ###  #########  ###
    ### Menu Hanlde ###
    ###  #########  ###
    ### ########### ###
    ###################
    
def MenuHandler1(userid, choice, popupname):
    if (choice == "Fun Commands"): SACMenu_Fun.send(userid)
    elif (choice == "Music"): SACMenu_Music.send(userid)
    elif (choice == "Propmenu"): SACMenu_Propmenu.send(userid)
    elif (choice == "Mini-Games"): SACMenu_MiniGames.send(userid)
    elif (choice == "Admin Management"): SACMenu_AdminManagement.send(userid)
    elif (choice == "Wolves VS Sheeps"):
        SACMenu_MiniGames.send(userid)
        es.unload("%s/mini_zombiemod" %(str(addonpath)))
        es.reload("%s/wolves_vs_sheeps" %(str(addonpath)))
        es.server.queuecmd("mp_restartgame 3")
        for Player in playerlib.getUseridList('#human'): tell(Player, translations('enabled_wolves_vs_sheeps', {'name':es.getplayername(userid)}, Lang(Player)))
        
    elif (choice == "Mini Zombiemod"):
        SACMenu_MiniGames.send(userid)
        es.unload("%s/wolves_vs_sheeps" %(str(addonpath)))
        es.reload("%s/mini_zombiemod" %(str(addonpath)))
        es.server.queuecmd("mp_restartgame 3")
        for Player in playerlib.getUseridList('#human'): tell(Player, translations('enabled_mini_zombiemod', {'name':es.getplayername(userid)}, Lang(Player)))
    elif (choice == "Stop MiniGames"):
        SACMenu_MiniGames.send(userid)
        es.server.queuecmd("es_xunload %s/mini_zombiemod" %(addonpath))
        es.server.queuecmd("es_xunload %s/wolves_vs_sheeps" %(addonpath))
        es.server.queuecmd("mp_restartgame 3")
        for Player in playerlib.getUseridList('#human'): tell(Player, translations('disabled_minigames', {'name':es.getplayername(userid)}, Lang(Player)))
    
def MenuHandler2(userid, choice, popupname):
    if (choice == "List of admins"):
        File = open(es.getAddonPath(addonpath) + '/admins.txt')
        tell(userid, " ")
        tell(userid, " ")
        tell(userid, " ")
        tell(userid, "---- ---- ---- ---- ---- ---- ---- ---- ----")
        tell(userid, "SAC Admins:")
        for CurrentLine in File.readlines():
            if (str(CurrentLine).lower().startswith("|steam_")):
                SplittedLine = CurrentLine.split("|")
                if (len(SplittedLine) == 4):
                    tell(userid, "---- ---- ---- ---- ---- ---- ---- ---- ----")
                    tell(userid, "%s%s" %(translations('Name', None, Lang(userid)), SplittedLine[3]))
                    tell(userid, "%s%s" %(translations('SteamID', None, Lang(userid)), SplittedLine[1]))
                    if (es.getuserid(SplittedLine[1])): tell(userid, "%s%s" %(translations('Status', None, Lang(userid)), translations('currently_online', {'name':es.getplayername(es.getuserid(SplittedLine[1]))}, Lang(userid))))
                    else: tell(userid, "%s%s" %(translations('Status', None, Lang(userid)), translations('currently_offline', None, Lang(userid))))
                    if (int(SplittedLine[2])): tell(userid, "%s%s" %(translations('Power', None, Lang(userid)), translations('can_edit_admins', None, Lang(userid))))
                    else: tell(userid, "%s%s" %(translations('Power', None, Lang(userid)), translations('cant_edit_admins', None, Lang(userid))))
        tell(userid, "---- ---- ---- ---- ---- ---- ---- ---- ----")
        tell(userid, translations('check_console', None, Lang(userid)))
        tell(userid, "---- ---- ---- ---- ---- ---- ---- ---- ----")
        SACMenu_AdminManagement.send(userid)
    elif (choice == "Add an Admin"):
        if (IsAdmin(userid) == 2):
            if popuplib.exists('AddAnAdminMenu'):
                popuplib.delete('AddAnAdminMenu')
            global AddAnAdminMenu
            AddAnAdminMenu = popuplib.easymenu('AddAnAdminMenu',None, AddAnAdminBlock)
            AddAnAdminMenu.settitle('- Super Admin CheeTaH')
            AddAnAdminMenu.setdescription("-- Admin Management\n---Add An Admin")
            AddAnAdminMenu.submenu(10, SACMenu_AdminManagement)
            AddAnAdminMenu.addoption('UpdateList', '--- Update List ---')
            AddAnAdminMenu.addoption('----------', ' ', 0)
            for Player in sorted(playerlib.getUseridList('#all'), key=lambda player: es.getplayername(player)): AddAnAdminMenu.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
            AddAnAdminMenu.send(userid)
        else:
            tell(userid, translations('no_access_to_add_or_remove_admins', None, Lang(userid)))
            SACMenu_AdminManagement.send(userid)
    elif (choice == "Remove an Admin"):
        if (IsAdmin(userid) == 2):
            if popuplib.exists('RemoveAnAdminMenu'):
                popuplib.delete('RemoveAnAdminMenu')
            global RemoveAnAdminMenu
            RemoveAnAdminMenu = popuplib.easymenu('RemoveAnAdminMenu',None, RemoveAnAdminBlock)
            RemoveAnAdminMenu.settitle('- Super Admin CheeTaH')
            RemoveAnAdminMenu.setdescription("-- Admin Management\n---Remove An Admin")
            RemoveAnAdminMenu.submenu(10, SACMenu_AdminManagement)
            RemoveAnAdminMenu.addoption('UpdateList', '--- Update List ---')
            RemoveAnAdminMenu.addoption('----------', ' ', 0)
            File = open(es.getAddonPath(addonpath) + '/admins.txt')
            for CurrentLine in File.readlines():
                if (str(CurrentLine).lower().startswith("|steam_")):
                    SplittedLine = CurrentLine.split("|")
                    if (len(SplittedLine) == 4): RemoveAnAdminMenu.addoption(SplittedLine[3], SplittedLine[3])
            RemoveAnAdminMenu.send(userid)
                        
        else:
            tell(userid, translations('no_access_to_add_or_remove_admins', None, Lang(userid)))
            SACMenu_AdminManagement.send(userid)
    
def PropCreator(userid, choice, popupname):
    SACMenu_Propmenu.send(userid)
    if (str(choice).startswith("D|")):
        choiceSplit = choice.split("|")
        if (len(choiceSplit) == 3):
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('spawned_prop', {'name':es.getplayername(userid),'prop':choiceSplit[1]}, Lang(Player)))
            es.prop_dynamic_create(userid, choiceSplit[2])
            return
    elif (str(choice).startswith("P|")):
        choiceSplit = choice.split("|")
        if (len(choiceSplit) == 3):
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('spawned_prop', {'name':es.getplayername(userid),'prop':choiceSplit[1]}, Lang(Player)))
            es.prop_physics_create(userid, choiceSplit[2])
            return
    elif (choice == "DelAll"):
        for Player in playerlib.getUseridList('#human'): tell(Player, translations('deleted_all_props', {'name':es.getplayername(userid)}, Lang(Player)))
        for entity_index in es.createentitylist():
            if str(es.entitygetvalue(entity_index, "classname")).startswith("prop_"):
                es.remove(entity_index)
        return
    elif (choice == "DelThis"):
        index = getViewProp(userid)
        if index != None and es.entitygetvalue(index, "classname").startswith("prop_"):
            es.remove(index)
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('deleted_a_prop', {'name':es.getplayername(userid)}, Lang(Player)))
            return
        tell(userid, translations('not_a_prop', None, Lang(userid)))
    
def MusicPlayer(userid, choice, popupname):
    es.emitsound("player", userid, choice, 1, 0)
    for Player in playerlib.getUseridList('#human'): tell(Player, translations('played_song', {'name':es.getplayername(userid),'song':choice}, Lang(Player)))
    SACMenu_Music.send(userid)
    
def AddAnAdminBlock(userid, choice, popupname):
    if (choice == "UpdateList"):
        MenuHandler2(userid, "Add an Admin", None)
        return
    addAdmin(choice, userid)
    
def RemoveAnAdminBlock(userid, choice, popupname):
    if (choice == "UpdateList"):
        MenuHandler2(userid, "Remove an Admin", None)
        return
    removeAdmin(choice, userid)
    
def MenuHandler3(userid, choice, popupname):
    if (choice == 'Respawn'):
        Menu = 'RespawnMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None, RespawnBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#dead'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            if (int(es.getplayerteam(Player)) == 2): Menu2.addoption(Player, '[T] %s (%s)' %(es.getplayername(Player), Player))
            if (int(es.getplayerteam(Player)) == 3): Menu2.addoption(Player, '[CT] %s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Godmode'):
        Menu = 'GodMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,GodBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            if (playerlib.getPlayer(Player).inGodMode()): Menu2.addoption(Player, '[GOD] %s (%s)' %(es.getplayername(Player), Player))
            else: Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Speed'):
        Menu = 'SpeedMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,SpeedBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            if (playerlib.getPlayer(Player).getSpeed() != 1.0): Menu2.addoption(Player, '[Speed] %s (%s)' %(es.getplayername(Player), Player))
            else: Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Jetpack'):
        Menu = 'JetpackMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,JetpackBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            if (playerlib.getPlayer(Player).getJetpack()): Menu2.addoption(Player, '[Jetpack] %s (%s)' %(es.getplayername(Player), Player))
            else: Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Gravity'):
        Menu = 'GravityMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,GravityBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            Menu2.addoption(Player, '[Gravity: %s] %s (%s)' %(SAC_Dict_Gravity[int(Player)], es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Invisible'):
        Menu = 'InvisibleMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,InvisibleBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            Visibilityness = str(playerlib.getPlayer(Player).getColor()).split(", ")[3].replace(")", "")
            Menu2.addoption(Player, '[%03d/255] %s (%s)' %(int(Visibilityness), es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Shake'):
        Menu = 'ShakeMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,ShakeBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            if SAC_Dict_Shaking[int(Player)] != "0": Menu2.addoption(Player, '[SHAKING: %03d] %s (%s)' %(int(SAC_Dict_Shaking[int(Player)]), es.getplayername(Player), Player))
            if SAC_Dict_Shaking[int(Player)] == "0": Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Unlimited Ammo'):
        Menu = 'UnlimitedAmmoMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,UnlimitedAmmoBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            if SAC_Dict_Ammo[int(Player)] != "0": Menu2.addoption(Player, '[UNLIMITED AMMO] %s (%s)' %(es.getplayername(Player), Player))
            if SAC_Dict_Ammo[int(Player)] == "0": Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Disarm'):
        Menu = 'DisarmMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,DisarmBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Regeneration'):
        Menu = 'RegenerationMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,RegenerationBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            if SAC_Dict_Regeneration[int(Player)] != "0": Menu2.addoption(Player, '[REG] %s (%s)' %(es.getplayername(Player), Player))
            if SAC_Dict_Regeneration[int(Player)] == "0": Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Disguise'):
        Menu = 'DisguiseMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,DisguiseBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            if SAC_Dict_Disguise[int(Player)] != "0": Menu2.addoption(Player, '[DIS] %s (%s)' %(es.getplayername(Player), Player))
            if SAC_Dict_Disguise[int(Player)] == "0": Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Bury'):
        Menu = 'BuryMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,BuryBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Blind'):
        Menu = 'BlindMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,BlindBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            Menu2.addoption(Player, '[%03d/255] %s (%s)' %(int(SAC_Dict_Blind[Player]), es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Slay'):
        Menu = 'SlayMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,SlayBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Save Location'):
        x,y,z = es.getplayerlocation(userid)
        SAC_Dict_Saveloc[userid] = "%f,%f,%f" %(float(x),float(y),float(z))
        tell(userid, translations('saveloc',{'x':x,'y':y,'z':z},Lang(userid)))
        SACMenu_Fun.send(userid)
        
    elif (choice == 'Teleport'):
        if int(userid) not in SAC_Dict_Saveloc:
            tell(userid, translations('no_savedloc',None,Lang(userid)))
            SACMenu_Fun.send(userid)
            return
        Menu = 'TeleportMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,TeleportBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Burn'):
        Menu = 'BurnMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,BurnBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            Menu2.addoption(Player, '[Burning %02d] %s (%s)' %(int(SAC_Dict_Burn[int(Player)]),es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Drug'):
        Menu = 'DrugMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,DrugBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            if SAC_Dict_Drug[int(Player)] != "0": Menu2.addoption(Player, '[DRUGGED] %s (%s)' %(es.getplayername(Player), Player))
            if SAC_Dict_Drug[int(Player)] == "0": Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
        
    elif (choice == 'Slap'):
        Menu = 'SlapMenu'
        if popuplib.exists(Menu): popuplib.delete(Menu)
        Menu2 = popuplib.easymenu(Menu,None,SlapBlock)
        Menu2.settitle('- Super Admin CheeTaH')
        Menu2.setdescription("--Fun Commands \n---%s" %(choice), lang=None)
        Menu2.submenu(10, SACMenu_Fun)
        Menu2.addoption('UpdateList', '--- Update List ---')
        SearchFor = '#alive'
        Players = playerlib.getUseridList(SearchFor)
        Players = sorted(Players, key=lambda player: es.getplayername(player))
        if (Players): Menu2.addoption('----------', ' ', 0)
        else: Menu2.addoption('----------', translations('none_matching', {'arg':str(SearchFor).replace("#", "")}, Lang(userid)), 0)
        for Player in Players:
            Menu2.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
        Menu2.send(userid)
    
    
    ###################
    ### ########### ###
    ###  #########  ###
    ### Client CMDs ###
    ###  #########  ###
    ### ########### ###
    ###################
def client_cmd_openmenu(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    SACMenu_Main.send(Doer)
    
def client_cmd_respawn(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 1
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Respawn', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            PlayerP = playerlib.getPlayer(Doed)
            PlayerName = es.getplayername(Doed)
            if not (PlayerP.isdead):
                tell(Doer, translations('already_alive', {'name':PlayerName}, Lang(Doer)))
                continue
            es.setplayerprop(Doed,"CCSPlayer.m_iPlayerState",0)
            es.setplayerprop(Doed,"CCSPlayer.baseclass.m_lifeState",512)
            es.spawnplayer(Doed)
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('respawned', {'DoedName':PlayerName,'DoerName':DoerName}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_godmode(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 1
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Godmode', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            if (DoedP.inGodMode()):
                DoedP.godmode(0)
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('god_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
            else:
                DoedP.godmode(1)
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('god_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))

    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_speed(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 2
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Speed', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            es.setplayerprop(Doed, "CBasePlayer.localdata.m_flLaggedMovementValue", args[1])
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('speed', {'DoedName':DoedName,'DoerName':DoerName,'speed':args[1]}, Lang(Player)))

    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_jetpack(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 1
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Jetpack', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            if (DoedP.getJetpack()):
                DoedP.jetpack(0)
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('jetpack_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
            else:
                DoedP.jetpack(1)
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('jetpack_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))

    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_gravity(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 2
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Gravity', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            SAC_Dict_Gravity[Doed] = args[1]
            es.fire(Doed, "!self", "addoutput", "gravity %s" %(args[1]))
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('gravity', {'DoedName':DoedName,'DoerName':DoerName,'gravity':args[1]}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
        
def client_cmd_invisible(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 2
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Invisible', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if int(args[1]) > 255: args[1] = 255
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            if DoedP.getPrimary(): DoedP.setWeaponColor(255, 255, 255, int(args[1]))
            elif DoedP.getSecondary(): DoedP.setWeaponColor(255, 255, 255, int(args[1]))
            procent = round(float(args[1]) / 2.55, 2)
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('invisible', {'DoedName':DoedName,'DoerName':DoerName,'real':args[1],'procent':procent}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_shake(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 2
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Shake', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            if(int(float(args[1])) == 0):
                SAC_Dict_Shaking[int(Doed)] = "0"
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('shaked_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
            else:
                SAC_Dict_Shaking[int(Doed)] = int(float(args[1]))
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('shaked_on', {'DoedName':DoedName,'DoerName':DoerName,'mag':SAC_Dict_Shaking[int(Player)]}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_unlimitedammo(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 1
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Unlimited Ammo', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            if (SAC_Dict_Ammo[int(Doed)] != "0"):
                    SAC_Dict_Ammo[int(Doed)] = "0"
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('unlimited_ammo_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
            else:
                SAC_Dict_Ammo[int(Doed)] = "1"
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('unlimited_ammo_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_disarm(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 1
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Unlimited Ammo', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            es.give(Doed, 'player_weaponstrip')
            es.fire(Doed, 'player_weaponstrip', 'strip')
            es.fire(Doed, 'player_weaponstrip', 'kill')
            DoedP.setSpeed(1.25)
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('disarm', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
        
    
def client_cmd_regeneration(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 1
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Regeneration', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            if (SAC_Dict_Regeneration[int(Doed)] != "0"):
                    SAC_Dict_Regeneration[int(Doed)] = "0"
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('regeneration_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
            else:
                SAC_Dict_Regeneration[int(Doed)] = "1"
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('regeneration_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_disguise(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 1
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Disguise', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            if (SAC_Dict_Disguise[int(Doed)] != "0"):
                SAC_Dict_Disguise[int(Doed)] = "0"
                RandomValue = int(random.randint(1,4))
                if (int(es.getplayerteam(Doed)) == 2):
                    if (RandomValue == 1): DoedP.setModel("player/t_arctic")
                    if (RandomValue == 2): DoedP.setModel("player/t_guerilla")
                    if (RandomValue == 3): DoedP.setModel("player/t_leet")
                    if (RandomValue == 4): DoedP.setModel("player/t_phoenix")
                if (int(es.getplayerteam(Doed)) == 3):
                    if (RandomValue == 1): DoedP.setModel("player/ct_gign")
                    if (RandomValue == 2): DoedP.setModel("player/ct_gsg9")
                    if (RandomValue == 3): DoedP.setModel("player/ct_sas")
                    if (RandomValue == 4): DoedP.setModel("player/ct_urban")
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('disguise_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
            else:
                SAC_Dict_Disguise[int(Doed)] = "1"
                DoedP.setModel("props_c17/oildrum001.mdl")
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('disguise_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_bury(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 2
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Bury', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            x,y,z = es.getplayerlocation(Doed)
            z -= float(args[1])
            es.entitysetvalue(DoedP.index, 'origin', ' '.join(es.createvectorstring(x,y,z).split(',')))
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('bury', {'DoedName':DoedName,'DoerName':DoerName,'depth':args[1]}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_blind(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 2
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Blind', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            SAC_Dict_Blind[int(Doed)] = args[1]
            procent = round(float(args[1]) / 2.55, 2)
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('blind', {'DoedName':DoedName,'DoerName':DoerName,'real':args[1],'procent':procent}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_kill(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 1
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Slay', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            DoedP.slay()
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('slay', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_saveloc(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    x,y,z = es.getplayerlocation(Doer)
    SAC_Dict_Saveloc[Doer] = "%f,%f,%f" %(float(x),float(y),float(z))
    tell(Doer, translations('saveloc',{'x':x,'y':y,'z':z},Lang(Doer)))
    
    
def client_cmd_teleport(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    if int(Doer) not in SAC_Dict_Saveloc:
        tell(Doer, translations('no_savedloc',None,Lang(Doer)))
        return
    WantedArgs = 1
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Teleport', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            es.entitysetvalue(DoedP.index, 'origin', ' '.join(SAC_Dict_Saveloc[int(Doer)].split(',')))
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('teleport', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_burn(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 2
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Burn', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            if (int(args[1]) == 0):
                SAC_Dict_Burn[int(Doed)] = 0
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('burn_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
            else:
                SAC_Dict_Burn[int(Doed)] = int(int(args[1]) * 10)
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('burn_on', {'DoedName':DoedName,'DoerName':DoerName,'time':int(int(SAC_Dict_Burn[int(Doed)]) / 10)}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_drug(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 1
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Drug', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            if (SAC_Dict_Drug[int(Doed)] != "0"):
                SAC_Dict_Drug[int(Doed)] = "0"
                es.cexec(Doed, "r_screenoverlay normal")
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('drug_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
            else:
                SAC_Dict_Drug[int(Doed)] = "1"
                es.cexec(Doed, "r_screenoverlay effects/tp_eyefx/tp_eyefx")
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('drug_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
def client_cmd_slap(Doer, args):
    if not IsAdmin(Doer):
        NotAdmin(Doer)
        return
    WantedArgs = 2
    if (len(args) != WantedArgs):
        tell(Doer, translations('wrong_syntax',{'given':len(args),'needed':WantedArgs},Lang(Doer)))
        gamethread.delayed(0.01, MenuHandler3, (Doer, 'Slap', None))
        return
    DoerName = es.getplayername(Doer)
    Players = playerlib.getUseridList(args[0])
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players):
        for Doed in Players:
            DoedP = playerlib.getPlayer(Doed)
            DoedName = es.getplayername(Doed)
            if (DoedP.isdead):
                tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
                continue
            x = random.randint(-200, 200)
            y = random.randint(-200, 200)
            z = random.randint(200, 400)
            es.emitsound("player", Doed, 'player/damage%s.wav'%(random.randint(1,3)), 1, 0.2)
            es.setplayerprop(Doed, "CCSPlayer.baseclass.localdata.m_vecBaseVelocity", es.createvectorstring(x,y,z))
            DoedP.setHealth(int(DoedP.getHealth()) - int(args[1]))
            if (int(DoedP.getHealth()) < 1): DoedP.slay()
            for Player in playerlib.getUseridList('#human'): tell(Player, translations('slap', {'DoedName':DoedName,'DoerName':DoerName, 'dmg':args[1]}, Lang(Player)))
    else:
        tell(Doer, translations('none_matching', {'arg':args[0]}, Lang(Doer)))
    
    
    ###############################
    ### ####################### ###
    ###  #####################  ###
    ### Menu handle for players ###
    ###  #####################  ###
    ### ####################### ###
    ###############################
def RespawnBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if not (DoedP.isdead): tell(Doer, translations('already_alive', {'name':DoedName}, Lang(Doer)))
            else:
                es.setplayerprop(Doed,"CCSPlayer.m_iPlayerState",0)
                es.setplayerprop(Doed,"CCSPlayer.baseclass.m_lifeState",512)
                es.spawnplayer(Doed)
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('respawned', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Respawn', None))
    
def GodBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                if (DoedP.inGodMode()):
                    DoedP.godmode(0)
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('god_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
                else:
                    DoedP.godmode(1)
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('god_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Godmode', None))
    
def SpeedBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                if (playerlib.getPlayer(Doed).getSpeed() != 1.0):
                    es.setplayerprop(Doed, "CBasePlayer.localdata.m_flLaggedMovementValue", "1.0")
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('speed', {'DoedName':DoedName,'DoerName':DoerName,'speed':'1.0'}, Lang(Player)))
                else:
                    es.setplayerprop(Doed, "CBasePlayer.localdata.m_flLaggedMovementValue", "2.0")
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('speed', {'DoedName':DoedName,'DoerName':DoerName,'speed':'2.0'}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Speed', None))
    
def JetpackBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                if (DoedP.getJetpack()):
                    DoedP.jetpack(0)
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('jetpack_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
                else:
                    DoedP.jetpack(1)
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('jetpack_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Jetpack', None))
    
def GravityBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                if (SAC_Dict_Gravity[Doed] != "1"):
                    SAC_Dict_Gravity[Doed] = "1"
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('gravity', {'DoedName':DoedName,'DoerName':DoerName,'gravity':'1'}, Lang(Player)))
                else:
                    SAC_Dict_Gravity[Doed] = "0.40"
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('gravity', {'DoedName':DoedName,'DoerName':DoerName,'gravity':'0.40'}, Lang(Player)))
                es.fire(Doed, "!self", "addoutput", "gravity %s" %(SAC_Dict_Gravity[Doed]))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Gravity', None))
    
def InvisibleBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                Visibilityness = str(playerlib.getPlayer(Doed).getColor()).split(", ")[3].replace(")", "")
                if (int(Visibilityness) == 0): VisValue = 51
                elif (int(Visibilityness) == 51): VisValue = 102
                elif (int(Visibilityness) == 102): VisValue = 153
                elif (int(Visibilityness) == 153): VisValue = 204
                elif (int(Visibilityness) == 255): VisValue = 0
                else: VisValue = 255
                DoedP.setColor(255, 255, 255, int(VisValue))
                if DoedP.getPrimary(): DoedP.setWeaponColor(255, 255, 255, int(VisValue))
                elif DoedP.getSecondary(): DoedP.setWeaponColor(255, 255, 255, int(VisValue))
                procent = round(float(VisValue) / 2.55, 2)
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('invisible', {'DoedName':DoedName,'DoerName':DoerName,'real':VisValue,'procent':procent}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Invisible', None))
    
def ShakeBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                if (SAC_Dict_Shaking[int(Doed)] != "0"):
                    SAC_Dict_Shaking[int(Doed)] = "0"
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('shaked_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
                else:
                    SAC_Dict_Shaking[int(Doed)] = "50"
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('shaked_on', {'DoedName':DoedName,'DoerName':DoerName,'mag':SAC_Dict_Shaking[int(Player)]}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Shake', None))
    
def UnlimitedAmmoBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                if (SAC_Dict_Ammo[int(Doed)] != "0"):
                    SAC_Dict_Ammo[int(Doed)] = "0"
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('unlimited_ammo_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
                else:
                    SAC_Dict_Ammo[int(Doed)] = "1"
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('unlimited_ammo_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Unlimited Ammo', None))
    
def DisarmBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                es.give(Doed, 'player_weaponstrip')
                es.fire(Doed, 'player_weaponstrip', 'strip')
                es.fire(Doed, 'player_weaponstrip', 'kill')
                DoedP.setSpeed(1.25)
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('disarm', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Disarm', None))
    
def RegenerationBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                if (SAC_Dict_Regeneration[int(Doed)] != "0"):
                    SAC_Dict_Regeneration[int(Doed)] = "0"
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('regeneration_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
                else:
                    SAC_Dict_Regeneration[int(Doed)] = "1"
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('regeneration_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Regeneration', None))
    
def DisguiseBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                if (SAC_Dict_Disguise[int(Doed)] != "0"):
                    SAC_Dict_Disguise[int(Doed)] = "0"
                    RandomValue = int(random.randint(1,4))
                    if (int(es.getplayerteam(Doed)) == 2):
                        if (RandomValue == 1): DoedP.setModel("player/t_arctic")
                        if (RandomValue == 2): DoedP.setModel("player/t_guerilla")
                        if (RandomValue == 3): DoedP.setModel("player/t_leet")
                        if (RandomValue == 4): DoedP.setModel("player/t_phoenix")
                    if (int(es.getplayerteam(Doed)) == 3):
                        if (RandomValue == 1): DoedP.setModel("player/ct_gign")
                        if (RandomValue == 2): DoedP.setModel("player/ct_gsg9")
                        if (RandomValue == 3): DoedP.setModel("player/ct_sas")
                        if (RandomValue == 4): DoedP.setModel("player/ct_urban")
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('disguise_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
                else:
                    SAC_Dict_Disguise[int(Doed)] = "1"
                    DoedP.setModel("props_c17/oildrum001.mdl")
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('disguise_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Disguise', None))
    
def BuryBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                x,y,z = es.getplayerlocation(Doed)
                z -= 30
                es.entitysetvalue(DoedP.index, 'origin', ' '.join(es.createvectorstring(x,y,z).split(',')))
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('bury', {'DoedName':DoedName,'DoerName':DoerName,'depth':50}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Bury', None))

def BlindBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                Blindness = SAC_Dict_Blind[int(Doed)]
                if (int(Blindness) == 0): BlindValue = 153
                elif (int(Blindness) == 153): BlindValue = 175
                elif (int(Blindness) == 175): BlindValue = 200
                elif (int(Blindness) == 200): BlindValue = 225
                elif (int(Blindness) == 225): BlindValue = 250
                elif (int(Blindness) == 250): BlindValue = 255
                else: BlindValue = 0
                SAC_Dict_Blind[int(Doed)] = BlindValue
                procent = round(BlindValue / 2.55, 2)
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('blind', {'DoedName':DoedName,'DoerName':DoerName,'real':BlindValue,'procent':procent}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Blind', None))

def SlayBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                DoedP.slay()
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('slay', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Slay', None))

def TeleportBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                es.entitysetvalue(DoedP.index, 'origin', ' '.join(SAC_Dict_Saveloc[int(Doer)].split(',')))
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('teleport', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Teleport', None))

def BurnBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                if (SAC_Dict_Burn[int(Doed)] != 0):
                    SAC_Dict_Burn[int(Doed)] = 0
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('burn_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
                else:
                    SAC_Dict_Burn[int(Doed)] = 50
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('burn_on', {'DoedName':DoedName,'DoerName':DoerName,'time':int(int(SAC_Dict_Burn[int(Doed)]) / 10)}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Burn', None))

def DrugBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                if (SAC_Dict_Drug[int(Doed)] != "0"):
                    SAC_Dict_Drug[int(Doed)] = "0"
                    es.cexec(Doed, "r_screenoverlay normal")
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('drug_off', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
                else:
                    SAC_Dict_Drug[int(Doed)] = "1"
                    es.cexec(Doed, "r_screenoverlay effects/tp_eyefx/tp_eyefx")
                    for Player in playerlib.getUseridList('#human'): tell(Player, translations('drug_on', {'DoedName':DoedName,'DoerName':DoerName}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Drug', None))

def SlapBlock(Doer, Doed, popupname):
    if not IsAdmin(Doer):
        NotAdmin(userid)
        return
    if (Doed != "UpdateList"):
        if not (es.exists('userid',Doed)): tell(Doer, translations('no_such_userid', {'userid':Doed}, Lang(Doer)))
        else:
            DoerName = es.getplayername(Doer)
            DoedName = es.getplayername(Doed)
            DoedP = playerlib.getPlayer(Doed)
            if (DoedP.isdead): tell(Doer, translations('dead', {'name':DoedName}, Lang(Doer)))
            else:
                x = random.randint(-200, 200)
                y = random.randint(-200, 200)
                z = random.randint(200, 400)
                es.emitsound("player", Doed, 'player/damage%s.wav'%(random.randint(1,3)), 1, 0.2)
                es.setplayerprop(Doed, "CCSPlayer.baseclass.localdata.m_vecBaseVelocity", es.createvectorstring(x,y,z))
                for Player in playerlib.getUseridList('#human'): tell(Player, translations('slap', {'DoedName':DoedName,'DoerName':DoerName, 'dmg':'0'}, Lang(Player)))
    gamethread.delayed(0.01, MenuHandler3, (Doer, 'Slap', None))